<HTML>
<HEAD><link rel="stylesheet" href="style/normal_ws.css" type="text/css">
<TITLE>Add IP QoS Classification Rules</TITLE>
<meta http-equiv="Content-Type" content="text/html" charset="utf-8">

<style>
SELECT {width:200px;}
</style>

<SCRIPT language="javascript" src="common.js"></SCRIPT>
<SCRIPT language="javascript" type="text/javascript">

var dscps = new it_nr("dscplst", 
 new it(0, ""),
 new it(1, "default(000000)"), 
 new it(57, "AF13(001110)"), 
 new it(49, "AF12(001100)"), 
 new it(41, "AF11(001010)"),
 new it(33, "CS1(001000)"),
 new it(89, "AF23(010110)"),
 new it(81, "AF22(010100)"),
 new it(73, "AF21(010010)"),
 new it(65, "CS2(010000)"),
 new it(121, "AF33(011110)"),
 new it(113, "AF32(011100)"),
 new it(105, "AF31(011010)"),
 new it(97, "CS3(011000)"),
 new it(153, "AF43(100110)"),
 new it(145, "AF42(100100)"),
 new it(137, "AF41(100010)"),
 new it(129, "CS4(100000)"),
 new it(185, "EF(101110)"),
 new it(161, "CS5(101000)"),
 new it(193, "CS6(110000)"),
 new it(225, "CS7(111000)"));

<!--var protos = new Array("", "ICMP", "TCP", "UDP", "TCP/UDP");-->
var protos = new Array("", "TCP", "UDP", "ICMP", "TCP/UDP");
var states = new Array("disable", "enable");
var md802ps = new Array("", "0", "1", "2", "3", "4", "5", "6", "7");
//var iffs = new Array("", "LAN_1", "LAN_2", "LAN_3", "LAN_4");
var iffs = new it_nr("lanitf");
var quekeys = new it_nr("queuekey");
var oifkeys = new it_nr("outifkey");

var sel1 = new Array("phypt", "proto", "dscp", "sip", "smsk", "spts", "spte", "dip", "dmsk", "dpts", "dpte", "smac", "dmac",
					 "sip6", "sip6PrefixLen", "dip6", "dip6PrefixLen");
var sel2 = new Array("vlan1p");

var ipversions = new Array("Please select IP version", "IPv4", "IPv6");
//default
quekeys.add(new it("", ""));
quekeys.add(new it("1", "Queue 1"));
quekeys.add(new it("2", "Queue 2"));
quekeys.add(new it("3", "Queue 3"));
quekeys.add(new it("4", "Queue 4"));


iffs.add(new it(0, ""));
iffs.add(new it(1, "LAN_1"));
iffs.add(new it(2, "LAN_2"));
iffs.add(new it(3, "LAN_3"));
iffs.add(new it(4, "LAN_4"));

<!--oifkeys.add(new it("65535|255", ""));-->
//oifkeys.add(new it("65535", ""));
//oifkeys.add(new it("130816", "nas0_0"));
oifkeys.add(new it("327936", "ppp1"));
oifkeys.add(new it("0", "ppp0"));


//var opts = new Array(new Array("prio", quekeys), new Array("outif", oifkeys), new Array("proto", protos),
var opts = new Array(new Array("prio", quekeys), new Array("proto", protos),
	new Array("mdscp", dscps), new Array("m1p", md802ps), new Array("phypt", iffs),
	new Array("dscp", dscps), new Array("vlan1p", md802ps), new Array("IpProtocolType", ipversions) );

var rule = new it_nr("rule_");
var paramrl = sji_queryparam("rule");
rule.dec(paramrl);

function checkstr(str)
{
	var ch="";
	if(typeof str != "string") return 0;
	for(var i =0;i< str.length; i++) {
		ch = str.charAt(i);
		if(!(ch =="_"||(ch<="9"&&ch>="0")||(ch<="z"&&ch>="a")||(ch<="Z"&&ch>="A"))) return 0;
	}
	return 1;
}

function onChange_proto()
{
	for(var n2 in sel2)
	{
		var oin = document.getElementById(sel2[n2]);
		if(typeof oin == "undefined")continue;
		if(oin.tagName == "SELECT")oin.selectedIndex = 0;
		else oin.value = "";
	}

	with ( document.forms[0] )
	{
		if (proto.value == 5) {
			spts.disabled = true;
			spte.disabled = true;
			dpts.disabled = true;
			dpte.disabled = true;
		} else {
			spts.disabled = false;
			spte.disabled = false;
			dpts.disabled = false;
			dpte.disabled = false;
		}
	}
}

function onchange_sel1()
{
	for(var n2 in sel2)
	{
		var oin = document.getElementById(sel2[n2]);
		if(typeof oin == "undefined")continue;
		if(oin.tagName == "SELECT")oin.selectedIndex = 0;
		else oin.value = "";
	}
}

function onchange_sel2()
{
	for(var n1 in sel1)
	{
		var oin = document.getElementById(sel1[n1]);
		if(typeof oin == "undefined")continue;
		if(oin.tagName == "SELECT")oin.selectedIndex = 0;
		else oin.value = "";
	}
}

/********************************************************************
**          on document load
********************************************************************/
function on_init()
{	
	for(var i in opts)
	{
		var slit = document.getElementById(opts[i][0]);
		if(typeof slit == "undefined")continue;
		for(var j in opts[i][1])
		{
			if(j == "name" || (typeof opts[i][1][j] != "string" && typeof opts[i][1][j] != "number"))continue;
			slit.options.add(new Option(opts[i][1][j], j));
		}
		slit.selectedIndex = 0;
	}
	for(var key in rule)
	{
		if((typeof rule[key] != "string" && typeof rule[key] != "number"))continue;
		if(typeof form[key] == "undefined")continue;
		form[key].value =  rule[key];
	}	
	if ( 1 )
	{
		if (document.getElementById)  // DOM3 = IE5, NS6
		{
			document.getElementById('ipprotbl').style.display = 'block';						
		}
		else {
			if (document.layers == false) // IE4
			{
				document.all.ipprotbl.style.display = 'block';						
			}
		}
		
		protocolChange();
	}
}

/********************************************************************
**          on document submit
********************************************************************/
function on_submit() 
{
	with ( document.forms[0] )	{
		var sbmtstr = "addrule";
		if(paramrl != null)
			sbmtstr = "editrule";
		sbmtstr = sbmtstr+"&index="+index.value;
		if(!checkstr(name.value)) {
			name.value="";
			name.focus();
			alert("Rule Name is invalid!");
			return;
		} else {
			sbmtstr = sbmtstr+"&name="+name.value;
		}
		//sbmtstr = sbmtstr+"&state="+state.value;
		
		if(prio.value == "") {
			prio.focus();
			alert("Please assign used Queue!");
			return;
		} else {
			sbmtstr = sbmtstr+"&prio="+prio.value;
		}

		//condition check
		if (phypt.value==0 && proto.value==0 && dscp.value==0 && (sip.value=="" || 
			sip.value=="0.0.0.0") && (spts.value==0 || spts.value=="") && (dip.value=="" || 
			dip.value=="0.0.0.0") && (dpts.value==0 || dpts.value=="") && vlan1p.value==0 && 
			smac.value=="" && dmac.value=="" && sip6.value=="" && dip6.value=="")
		{
			alert("Need to specify one parameter at least!");
			return;
		}

		if (proto.value==5) {//RTP
			if (dpts.value!=0 && dpts.value!="")
			{
				alert("Protocol is RTP, can not specify Dst port!");
				return;
			}
		}
		
		sbmtstr = sbmtstr+"&outif="+outif.value;
		sbmtstr = sbmtstr+"&markdscp="+mdscp.value;
		sbmtstr = sbmtstr+"&mark1p="+m1p.value;
		sbmtstr = sbmtstr+"&phyport="+phypt.value;
		sbmtstr = sbmtstr+"&proto="+proto.value;
		sbmtstr = sbmtstr+"&matchdscp="+dscp.value;		
		
		if ( 1 ) {
			sbmtstr = sbmtstr+"&IPversion="+IpProtocolType.value;
			if(document.forms[0].IpProtocolType.value == 0) {
				alert("Please assign IP version!");
				return;
			}
			
			// If this is a IPv4 rule
			if(document.forms[0].IpProtocolType.value == 1) {
				if(sip.value!=""&&!sji_checkip(sip.value)) {
					sip.value = "";
					sip.focus();
					alert("Src IP is invalid!");
					return;
				} else {
					sbmtstr = sbmtstr+"&sip="+sip.value;
				}
				
				if(smsk.value!=""&&!sji_checkmask(smsk.value)) {
					smsk.value="";
					smsk.focus();
					alert("Src Mask is invalid!");
					return;
				} else {
					sbmtstr = sbmtstr+"&smask="+smsk.value;
				}
				
				if(dip.value!=""&&!sji_checkip(dip.value)) {
					dip.value = "";
					dip.focus();
					alert("Dst IP is invalid!");
					return;
				} else {
					sbmtstr = sbmtstr+"&dip="+dip.value;
				}
			}
			else {
				//If this is IPv6 rule.
				if(document.forms[0].IpProtocolType.value == 2){				
					if(sip6.value != ""){
						if (! isGlobalIpv6Address(sip6.value) ){
							alert("Invalid Source IPv6 address!");					
							return;
						}
						if ( sip6PrefixLen.value != "" ) {
							var prefixlen= getDigit(sip6PrefixLen.value, 1);
							if (prefixlen > 128 || prefixlen <= 0) {
								alert("Invalid Source IPv6 prefix length!");							
								return;
							}
						}
					}
					
					if(dip6.value != ""){
						if (! isGlobalIpv6Address(dip6.value) ){
							alert("Invalid Destination IPv6 address!");					
							return;
						}
						if ( dip6PrefixLen.value != "" ) {
							var prefixlen= getDigit(dip6PrefixLen.value, 1);
							if (prefixlen > 128 || prefixlen <= 0) {
								alert("Invalid destination IPv6 prefix length!");							
								return;
							}
						}
					}
					sbmtstr = sbmtstr+"&sip6="+sip6.value;
					sbmtstr = sbmtstr+"&dip6="+dip6.value;
					sbmtstr = sbmtstr+"&sip6PrefixLen="+sip6PrefixLen.value;
					sbmtstr = sbmtstr+"&dip6PrefixLen="+dip6PrefixLen.value;					
				}
			}
		}
		else {
			if(sip.value!=""&&!sji_checkip(sip.value)) {
				sip.value = "";
				sip.focus();
				alert("Src IP is invalid!");
				return;
			} else {
				sbmtstr = sbmtstr+"&sip="+sip.value;
			}
			
			if(smsk.value!=""&&!sji_checkmask(smsk.value)) {
				smsk.value="";
				smsk.focus();
				alert("Src Mask is invalid!");
				return;
			} else {
				sbmtstr = sbmtstr+"&smask="+smsk.value;
			}
			
			if(dip.value!=""&&!sji_checkip(dip.value)) {
				dip.value = "";
				dip.focus();
				alert("Dst IP is invalid!");
				return;
			} else {
				sbmtstr = sbmtstr+"&dip="+dip.value;
			}
		}
		
		if(dmsk.value!=""&&!sji_checkmask(dmsk.value)) {
			dmsk.value="";
			dmsk.focus();
			alert("Dst Mask is invalid!");
			return;
		} else {
			sbmtstr = sbmtstr+"&dmask="+dmsk.value;
		}
		
		if(spts.value<0||spts.value>65536) {
			spts.focus();
			alert("Invalid Src Start Port!");
			return;
		} else {		     
			if (spts.value!=0 && proto.value!=1 && proto.value!=2 && proto.value!=4 ) {//TCP/UDP			
				alert("Protocol is not TCP/UDP, can not specify port!");
				return;
			}		
			sbmtstr = sbmtstr+"&spts="+spts.value;
		}
		
		if(spte.value<0||spte.value>65536) {
			spte.focus();
			alert("Invalid Src End Port!");
			return;
		} else {
			if (spte.value!=0 && proto.value!=1 && proto.value!=2 && proto.value!=4) {//TCP/UDP			
				alert("Protocol is not TCP/UDP, can not specify port!");
				return;
			}
			sbmtstr = sbmtstr+"&spte="+spte.value;
		}		
		
		if(dpts.value<0||dpts.value>65536) {
			dpts.focus();
			alert("Invalid Dst Start Port!");
			return;
		} else {
			if (dpts.value!=0 && proto.value!=1 && proto.value!=2 && proto.value!=4) {//TCP/UDP			
				alert("Protocol is not TCP/UDP, can not specify port!");
				return;
			}
			sbmtstr = sbmtstr+"&dpts="+dpts.value;
		}
		
		if(dpte.value<0||dpte.value>65536) {
			dpte.focus();
			alert("Invalid Dst End Port!");
			return;
		} else {
			if (dpte.value!=0  && proto.value!=1 && proto.value!=2 && proto.value!=4) {//TCP/UDP			
				alert("Protocol is not TCP/UDP, can not specify port!");
				return;
			}
			sbmtstr = sbmtstr+"&dpte="+dpte.value;			
		}

		if(smac.value!=""&&!sji_checkmac2(smac.value)) {
			smac.value = "";
			smac.focus();
			alert("Invalid Src MAC!");
			return;
		} else {
			sbmtstr = sbmtstr+"&smac="+smac.value;
		}

		if(dmac.value!=""&&!sji_checkmac2(dmac.value)) {
			dmac.value = "";
			dmac.focus();
			alert("Invalid Dst MAC!");
			return;
		} else {
			sbmtstr = sbmtstr+"&dmac="+dmac.value;
		}	
		
		sbmtstr = sbmtstr+"&vlan1p="+vlan1p.value;		
		lst.value = sbmtstr;
		submit();
	}
}

function protocolChange()
{	
	// If protocol is IPv4 only.
	if(document.forms[0].IpProtocolType.value == 1){			
		if (document.getElementById)  // DOM3 = IE5, NS6
		{
			document.getElementById('ip4tbl').style.display = 'block';
			document.getElementById('ip6tbl').style.display = 'none';						
		}
		else {
			if (document.layers == false) // IE4
			{
				document.all.ip4tbl.style.display = 'block';
				document.all.ip6tbl.style.display = 'none';						
			}
		}			
	}
	// If protocol is IPv6 only.
	else if(document.forms[0].IpProtocolType.value == 2){			
		if (document.getElementById)  // DOM3 = IE5, NS6
		{
			document.getElementById('ip4tbl').style.display = 'none';
			document.getElementById('ip6tbl').style.display = 'block';			
		}
		else {
			if (document.layers == false) // IE4
			{
				document.all.ip4tbl.style.display = 'none';
				document.all.ip6tbl.style.display = 'block';						
			}
		}
	}	
}

</SCRIPT>
</HEAD>

<body onLoad="on_init();">
	<blockquote>
		<DIV align="left" style="padding-left:20px; padding-top:5px;">
			<!--<form id="form" action="/boaform/admin/formQosRuleEdit" method="post">-->
			<form id="form" action="net_qos_cls_edit.asp" method="post">
				<H2>Add IP QoS Classification Rules</H2>				
				<div class="tip" style="width:90% ">
					&nbsp;&nbsp;This page is used to add a IP QoS classification rule.<br>
				</div>
				<br>				
				<hr class="sep" size="1" width="90%">
				<br>				
				
				<div id='ipprotbl' style="display:none">
				<table cellSpacing="1" cellPadding="0" border="0">								
					<tr><td width="260px"><font size=2><b>IP Version:</b></td>
						<td><select id="IpProtocolType" size="1" onChange="protocolChange()" name="IpProtocolType">
							</select>
						</td>
					</tr>					
				</table>
				</div>
				
				<table cellSpacing="1" cellPadding="0" border="0">				
					<tr><td width="260px"><font size=2><b>Rule Name:</b></td><td><input type="text" id="name" size="22" style="width:200px "></td></tr>					
					
					<tr><td colspan="2">&nbsp; </td></tr>
					<tr><td colspan="2"><b>Assign IP Precedence/DSCP/802.1p to Egress Traffic</b></td></tr>					
					<tr><td colspan="2">&nbsp; </td></tr>
					<tr><td width="160px"><font size=2><b>Precedence:</b></td><td><select id="prio" size="1"></select></td></tr>
					<tr><td width="160px"><font size=2><b>DSCP:</b></td><td><select id="mdscp" size="1"></select></td></tr>
					<tr><td width="160px"><font size=2><b>802.1p:</b></td><td><select id="m1p" size="1"></select></td></tr>
					
					<tr><td colspan="2">&nbsp; </td></tr>
					<tr><td colspan="2"><b>Specify Ingress Traffic Classification Rules</b></td></tr>
					<tr><td colspan="2">Please specify Configuration - 1 Or Configuration - 2</td></tr>
					
					<tr><td colSpan="2">&nbsp; </td></tr>					
					<tr><td colSpan="2"><font size=2><b>Configuration - 1</b></td></tr>
					<tr><td width="160px"><font size=2><b>WAN:</b></td><td><select id="outif" size="1"><option value=65535>Any</option>
<option value=130816>nas0_0</option>
<option value=327936>ppp1_ptm0_0</option>
<option value=0>ppp0_vc0_0</option>
</select></td></tr>
					<tr><td width="160px"><font size=2><b>Physical Port:</b></td><td><select id="phypt" size="1" onChange="onchange_sel1();"></select></td></tr>
					<tr><td width="160px"><font size=2><b>Protocol:</b></td><td><select id="proto" size="1" onChange="onChange_proto();"></select></td></tr>
					<tr><td width="160px"><font size=2><b>DSCP:</b></td><td><select id="dscp" size="1" onChange="onchange_sel1();"></select></td></tr>
				</table>
				
				<div id='ip4tbl' style="display:block;">
				<table cellSpacing="1" cellPadding="0" border="0">
					<tr><td width="260px"><font size=2><b>Source IP: </b></td><td><input type="text" id="sip" size="15" maxlength="15" style="width:200px " onChange="onchange_sel1();"></td></tr>
					<tr><td width="160px"><font size=2><b>Source Mask: </b></td><td><input type="text" id="smsk" size="15" maxlength="15" style="width:200px " onChange="onchange_sel1();"></td></tr>					
					<tr><td width="160px"><font size=2><b>Destination IP: </b></td><td><input type="text" id="dip" size="15" maxlength="15" style="width:200px " onChange="onchange_sel1();"></td></tr>
					<tr><td width="160px"><font size=2><b>Destination Mask: </b></td><td><input type="text" id="dmsk" size="15" maxlength="15" style="width:200px " onChange="onchange_sel1();"></td></tr>					
				</table>				
				</div>
				
				<div id='ip6tbl' style="display:none">
				<table cellSpacing="1" cellPadding="0" border="0">
					<tr><td width="260px"><font size=2><b>Source IP: </b></td><td><input type="text" id="sip6" size="36" maxlength="39" style="width:200px " onChange="onchange_sel1();"></td></tr>
					<tr><td width="160px"><font size=2><b>Source Prefix Length: </b></td><td><input type="text" id="sip6PrefixLen" size="15" maxlength="15" style="width:200px " onChange="onchange_sel1();"></td></tr>					
					<tr><td width="160px"><font size=2><b>Destination IP: </b></td><td><input type="text" id="dip6" size="36" maxlength="39" style="width:200px " onChange="onchange_sel1();"></td></tr>
					<tr><td width="160px"><font size=2><b>Destination Prefix Length: </b></td><td><input type="text" id="dip6PrefixLen" size="15" maxlength="15" style="width:200px " onChange="onchange_sel1();"></td></tr>					
				</table>
				</div>
				
				<table cellSpacing="1" cellPadding="0" border="0">
					<tr><td width="260px"><font size=2><b>Source Port: </b></td><td><input type="text" id="spts" size="5" maxlength="5" style="width:97px" onChange="onchange_sel1();">:<input type="text" id="spte" size="5" maxlength="5" style="width:97px" onChange="onchange_sel1();"></td></tr>
					<tr><td width="160px"><font size=2><b>Destination Port: </b></td><td><input type="text" id="dpts" size="5" maxlength="5" style="width:97px" onChange="onchange_sel1();">:<input type="text" id="dpte" size="5" maxlength="5" style="width:97px" onChange="onchange_sel1();"></td></tr>
					<tr><td width="160px"><font size=2><b>Source MAC:</b></td><td><input type="text" id="smac" size="17" maxlength="17" style="width:200px " onChange="onchange_sel1();"></td></tr>
					<tr><td width="160px"><font size=2><b>Destination MAC:</b></td><td><input type="text" id="dmac" size="17" maxlength="17" style="width:200px " onChange="onchange_sel1();"></td></tr>
				</table>
				
				<table cellSpacing="1" cellPadding="0" border="0">
					<tr><td colSpan="2">&nbsp; </td></tr>
					<tr><td colSpan="2"><font size=2><b>Configuration - 2</b></td></tr>
					<tr><td width="260px"><font size=2><b>802.1p:</b></td><td><select id="vlan1p" size="1" onChange="onchange_sel2();"></select></td></tr>
				</table>
				
				<hr class="sep" size="1" width="90%">
				<br>
				<input type="button" class="button" onClick="on_submit();" value="Apply Changes">
				<input type="hidden" name="submit-url" value="/net_qos_cls.asp">
				<input type="hidden" name="lst" value="">
				<input type="hidden" name="index" value="0">
			</form>
		</DIV>
	</blockquote>
</body>
</html>
